# Projecto SchoolAPI
Este projecto demonstra o funcionamento fictício de uma gestão de uma escola

## Notas

- pl5 para dia 8 
  - layouts 
  - intents
  - shared preferences
  - preparar ecrãs da schoolDiskApi,
      - ecrã inicial com botoes (configs, gerir estudantes, gerir notas, gerir professores)
      - ecrã criar professores
      - ecrã editar disciplinas do professor
      - ecrã apagar professores
- pl6 para dia 15
  - comunicar com http com threads
  - permissões
  - acrescentar um programa que usa a schoolDiskApi
    - ver tp7_01 do teams e tp5_05 para threads
    - uma lista de profs 
    - um criar professor
    - editar a lista de disciplinas do prof
    - apagar
- pl7 
  - getSystemService
  - location
  - sensors

## Usar só com java
- Instalar o java 11
- Na pasta do projecto executar o seguinte comando
````sh
java -jar dist/SchoolDiskAPI-0.0.1-SNAPSHOT.jar
````
caso falhe tentar o seguinte comando (Atenção que o número da versão pode variar de PC para PC):
````shell
"C:\Program Files\Amazon Corretto\jdk11.0.12_7\bin\java.exe" -jar dist/SchoolDiskAPI-0.0.1-SNAPSHOT.jar
````
- Consultar documentação em http://localhost:8585/swagger-ui.html
- Fazer pedidos rest


## Usar com gradle
- Na pasta do projecto executar o comando 
````shell
.\gradlew.bat bootRun
````
- Consultar documentação em http://localhost:8585/swagger-ui.html
- Fazer pedidos rest

## Usar em docker
- Compilar com gradle build
- executar o comando
````shell
 docker-compose up -d --build
````
- Consultar documentação em http://localhost:8585/swagger-ui.html
- Fazer pedidos rest
## Outros assuntos

### Restaurar dados
````shell
curl -X POST "http://localhost:8585/v1/school/restore" -H "accept: */*" 
````